import { __extends } from "tslib";
import { WebPlugin } from './index';
var AccessibilityPluginWeb = /** @class */ (function (_super) {
    __extends(AccessibilityPluginWeb, _super);
    function AccessibilityPluginWeb() {
        return _super.call(this, {
            name: 'Accessibility',
            platforms: ['web']
        }) || this;
    }
    AccessibilityPluginWeb.prototype.isScreenReaderEnabled = function () {
        throw new Error('Feature not available in the browser');
    };
    AccessibilityPluginWeb.prototype.speak = function (options) {
        if (!('speechSynthesis' in window)) {
            return Promise.reject('Browser does not support the Speech Synthesis API');
        }
        var utterance = new SpeechSynthesisUtterance(options.value);
        if (options.language) {
            utterance.lang = options.language;
        }
        window.speechSynthesis.speak(utterance);
        return Promise.resolve();
    };
    return AccessibilityPluginWeb;
}(WebPlugin));
export { AccessibilityPluginWeb };
var Accessibility = new AccessibilityPluginWeb();
export { Accessibility };
//# sourceMappingURL=accessibility.js.map